// When the DOM is fully loaded
document.addEventListener("DOMContentLoaded", function () {
    // Get the filter form by its ID
    const filterForm = document.getElementById("ysmap-filter-form");

    if (filterForm) {
        // Intercept form submission
        filterForm.addEventListener("submit", function () {
            // Try to find an existing 'paged' input
            let pagedInput = filterForm.querySelector("input[name='paged']");

            if (pagedInput) {
                // If found, reset its value to 1
                pagedInput.value = 1;
            } else {
                // If not found, create and append it
                let input = document.createElement("input");
                input.type = "hidden";
                input.name = "paged";
                input.value = 1;
                filterForm.appendChild(input);
            }
        });
    }
});


document.addEventListener('DOMContentLoaded', () => {
  const pinButtons = document.querySelectorAll('.ysmap-pin-toggle');

  pinButtons.forEach(button => {
    button.addEventListener('click', event => {
      event.preventDefault();

      const icon = button.querySelector('.dashicons');
      const postId = button.getAttribute('data-postid');

      // Show temporary spinner icon
      icon.classList.add('dashicons-update');

      // Perform AJAX request
      fetch(ajaxurl, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
          action: 'ysmap_toggle_pin',
          _ajax_nonce: ysmapAjax.nonce,
          post_id: postId
        })
      })
        .then(response => response.json())
        .then(data => {
          icon.classList.remove('dashicons-update');

          if (data.success) {
            // Toggle star icons
            if (icon.classList.contains('dashicons-star-empty')) {
              icon.classList.remove('dashicons-star-empty');
              icon.classList.add('dashicons-star-filled-alt');
            } else {
              icon.classList.remove('dashicons-star-filled-alt');
              icon.classList.add('dashicons-star-empty');
            }
          } else {
            alert('Failed to toggle pin.');
          }
        })
        .catch(() => {
          icon.classList.remove('dashicons-update');
          alert('AJAX error.');
        });
    });
  });
});

