<?php

if ( ! defined( 'ABSPATH' ) ) exit;

function ysmap_render_admin_page() {
    if (!current_user_can('edit_others_posts')) return;

    delete_transient('ysmap_cached_url_count');

    if (
        isset($_SERVER['REQUEST_METHOD']) &&
        $_SERVER['REQUEST_METHOD'] === 'POST' &&
        check_admin_referer('ysmap_save_exclusions')
    ) {
        $excluded = array_map('intval', $_POST['ysmap_excluded'] ?? []);
        update_option('ysmap_excluded_post_ids', $excluded);

        $excluded_taxonomies = array_map('sanitize_text_field', wp_unslash($_POST['ysmap_excluded_taxonomies'] ?? []));
        update_option('ysmap_excluded_taxonomies', $excluded_taxonomies);

        echo '<div class="notice notice-success"><p>' . esc_html__('Exclusions saved.', 'sitemap-manager-pro') . '</p></div>';
    }

    $excluded_ids = get_option('ysmap_excluded_post_ids', []);
    $selected_post_type = isset($_GET['post_type_filter']) ? sanitize_text_field(wp_unslash($_GET['post_type_filter'])) : 'all';
    $search_term = isset($_GET['ysmap_search']) ? sanitize_text_field(wp_unslash($_GET['ysmap_search'])) : '';
    $paged = max(1, isset($_GET['paged']) ? intval($_GET['paged']) : 1);
    $per_page = get_user_meta(get_current_user_id(), 'ysmap_per_page', true);
    if (!$per_page || $per_page < 1) $per_page = 100;

    $post_types = get_post_types(['public' => true], 'objects');

    echo '<div class="wrap">';
    echo '<h1>' . esc_html__('Sitemap Manager from 96 Monkeys', 'sitemap-manager-pro') . '</h1>';

    $args = [
        'post_status'    => 'publish',
        'posts_per_page' => $per_page,
        'paged'          => $paged,
        'orderby'        => $orderby,
        'order'          => $order,
    ];

    if ($selected_post_type === '__excluded__') {
        $args['post__in'] = $excluded_ids;
        $args['post_type'] = array_keys($post_types);
    } elseif ($selected_post_type !== 'all') {
        $args['post_type'] = $selected_post_type;
    } else {
        $args['post_type'] = array_keys($post_types);
    }

    if ($search_term) {
        $args['s'] = $search_term;
    }

    $query = new WP_Query($args);

    $count_args = [
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'fields'         => 'ids',
    ];

    if ($selected_post_type === '__excluded__') {
        $count_args['post__in'] = $excluded_ids;
        $count_args['post_type'] = array_keys($post_types);
    } elseif ($selected_post_type !== 'all') {
        $count_args['post_type'] = $selected_post_type;
    } else {
        $count_args['post_type'] = array_keys($post_types);
    }

    if ($search_term) {
        $count_args['s'] = $search_term;
    }

    $count_query = new WP_Query($count_args);
    $total_found = $count_query->post_count;

    $found_message = sprintf(
    /* translators: %s: number of URLs found. */
        _n( 'Found: %s URL', 'Found: %s URLs', $total_found, 'sitemap-manager-pro' ),
        number_format_i18n( $total_found )
    );
    
    echo '<p><strong>' . esc_html( $found_message ) . '</strong></p>';

    echo '<form method="post">';
    wp_nonce_field('ysmap_save_exclusions');

    echo '<table class="widefat fixed striped">';
    $title_sort_url = esc_url(add_query_arg(['orderby' => 'title', 'order' => ($orderby === 'title' && $order === 'ASC') ? 'desc' : 'asc']));
    $date_sort_url  = esc_url(add_query_arg(['orderby' => 'date',  'order' => ($orderby === 'date' && $order === 'ASC') ? 'desc' : 'asc']));

    echo '<thead><tr>';
    echo '<th style="width:20px;"><input type="checkbox" id="ysmap_check_all"></th>';
    echo '<th><a href="' . esc_url($title_sort_url) . '">' . esc_html__('Title', 'sitemap-manager-pro') . '</a></th>';
    echo '<th style="width:100px;"><a href="' . esc_url($date_sort_url) . '">' . esc_html__('Date', 'sitemap-manager-pro') . '</a></th>';
    echo '<th style="width:100px;">' . esc_html__('Post Type', 'sitemap-manager-pro') . '</th>';
    echo '<th>' . esc_html__('See Page', 'sitemap-manager-pro') . '</th>';
    echo '</tr></thead><tbody>';

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $id = get_the_ID();
            $checked_attr = in_array($id, $excluded_ids, true) ? ' checked="checked"' : '';
            $url_path = wp_parse_url(get_permalink(), PHP_URL_PATH);
            echo '<tr>';
            echo '<td><input type="checkbox" class="ysmap-post-row" name="ysmap_excluded[]" value="' . esc_attr($id) . '" data-title="' . esc_attr(get_the_title()) . '"' . esc_attr($checked_attr) . '></td>';
            echo '<td>' . esc_html(get_the_title()) . '</td>';
            echo '<td>' . esc_html(get_the_date('Y-m-d')) . '</td>';
            echo '<td>' . esc_html(get_post_type()) . '</td>';
            echo '<td><a href="' . esc_url(get_permalink()) . '" target="_blank">' . esc_html($url_path) . '</a></td>';
            echo '</tr>';
        }
        wp_reset_postdata();
    } else {
        echo '<tr><td colspan="5">' . esc_html__('No entries found.', 'sitemap-manager-pro') . '</td></tr>';
    }

    echo '</tbody></table>';

    $total_pages = $query->max_num_pages;
    if ($total_pages > 1) {
        echo '<div class="tablenav"><div class="tablenav-pages">';
        echo esc_attr(paginate_links([
            'base' => add_query_arg('paged', '%#%'),
            'format' => '',
            'current' => $paged,
            'total' => $total_pages,
        ]));
        echo '</div></div>';
    }

    $excluded_taxonomies = get_option('ysmap_excluded_taxonomies', []);
    $taxonomies = get_taxonomies(['public' => true], 'objects');

    echo '<h2>' . esc_html__('Exclude Entire Taxonomies from Sitemap', 'sitemap-manager-pro') . '</h2>';
    echo '<ul>';
    foreach ($taxonomies as $slug => $tax) {
        if ($slug === 'post_format') continue;
        $checked = in_array($slug, $excluded_taxonomies, true) ? ' checked="checked"' : '';
        echo '<li class="ysmap-taxonomy-row" style="display:block;"><label>';
        echo '<input type="checkbox" name="ysmap_excluded_taxonomies[]" value="' . esc_attr($slug) . '" data-taxlabel="' . esc_attr($tax->labels->singular_name) . '"' . esc_attr($checked) . '> ';
        echo esc_html($tax->labels->singular_name) . ' <em>ex: /' . esc_html($slug) . '/example/</em>';
        echo '</label></li>';
    }
    echo '</ul>';
    submit_button(__('Save Changes', 'sitemap-manager-pro'));
    echo '</form></div>';
}
