<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Toggle the pinned state for a post via AJAX.
 */
if ( ! function_exists( 'ysmap_ajax_toggle_pin' ) ) {
    function ysmap_ajax_toggle_pin() {
        // returns false instead of dying when invalid (3rd arg = false)
        if ( ! check_ajax_referer( 'ysmap_nonce', '_ajax_nonce', false ) ) {
            wp_send_json_error(
                array( 'message' => esc_html__( 'Invalid request. Please refresh and try again.', 'sitemap-manager-pro' ) ),
                403
            );
        }

        // Required param
        if ( ! isset( $_POST['post_id'] ) ) {
            wp_send_json_error( array( 'message' => __( 'Missing post_id.', 'sitemap-manager-pro' ) ), 400 );
        }

        $post_id = absint( wp_unslash( $_POST['post_id'] ) );
        if ( $post_id <= 0 ) {
            wp_send_json_error( array( 'message' => __( 'Invalid post_id.', 'sitemap-manager-pro' ) ), 400 );
        }

        // Capability & existence checks
        if ( ! current_user_can( 'edit_post', $post_id ) ) {
            wp_send_json_error( array( 'message' => __( 'You do not have permission to modify this post.', 'sitemap-manager-pro' ) ), 403 );
        }

        $post = get_post( $post_id );
        if ( ! $post ) {
            wp_send_json_error( array( 'message' => __( 'Post not found.', 'sitemap-manager-pro' ) ), 404 );
        }

        // Toggle meta
        $is_pinned = ( get_post_meta( $post_id, '_ysmap_pinned', true ) === '1' );

        if ( $is_pinned ) {
            delete_post_meta( $post_id, '_ysmap_pinned' );
            $new_state = false;
        } else {
            update_post_meta( $post_id, '_ysmap_pinned', '1' );
            $new_state = true;
        }

        wp_send_json_success( array(
            'post_id' => $post_id,
            'pinned'  => $new_state,
        ) );
    }
}

add_action( 'wp_ajax_ysmap_toggle_pin', 'ysmap_ajax_toggle_pin' );
// If you need this to work for non-logged-in users too, also add:
// add_action( 'wp_ajax_nopriv_ysmap_toggle_pin', 'ysmap_ajax_toggle_pin' );
