<?php

if ( ! defined( 'ABSPATH' ) ) exit;

// File: includes/filter-excluded-posts.php

// Ensure helper is available
if (!function_exists('ysmap_get_active_seo_plugin')) {
    require_once plugin_dir_path(__FILE__) . 'helpers.php';
}

$plugin = ysmap_get_active_seo_plugin();

// YOAST
if ($plugin === 'yoast') {
    add_filter('wpseo_exclude_from_sitemap_by_post_ids', function($excluded) {
        $custom_excluded = get_option('ysmap_excluded_post_ids', []);
        return array_unique(array_merge($excluded, $custom_excluded));
    });

    add_filter('wpseo_sitemap_exclude_taxonomy', function($exclude, $taxonomy) {
        $excluded_taxonomies = get_option('ysmap_excluded_taxonomies', []);
        return in_array($taxonomy, $excluded_taxonomies, true) ? true : $exclude;
    }, 10, 2);
}

// RANK MATH
elseif ($plugin === 'rankmath') {
    add_filter('rank_math/sitemap/exclude_post', function($exclude, $post_id) {
        $excluded_ids = get_option('ysmap_excluded_post_ids', []);
        return in_array($post_id, $excluded_ids, true) ? true : $exclude;
    }, 10, 2);

    add_filter('rank_math/sitemap/exclude_taxonomy', function($exclude, $taxonomy) {
        $excluded_taxonomies = get_option('ysmap_excluded_taxonomies', []);
        return in_array($taxonomy, $excluded_taxonomies, true) ? true : $exclude;
    }, 10, 2);
}

// AIOSEO
elseif ($plugin === 'aioseo') {
    add_filter('aioseo_sitemap_post_exclude', function($exclude, $post_id) {
        $excluded_ids = get_option('ysmap_excluded_post_ids', []);
        return in_array($post_id, $excluded_ids, true) ? true : $exclude;
    }, 10, 2);

    add_filter('aioseo_sitemap_taxonomy_exclude', function($exclude, $term, $taxonomy) {
        $excluded_taxonomies = get_option('ysmap_excluded_taxonomies', []);
        return in_array($taxonomy, $excluded_taxonomies, true) ? true : $exclude;
    }, 10, 3);
}
