<?php
// IMPORTANT: no BOM/whitespace before this line.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

status_header( 200 );
header( 'Content-Type: application/xml; charset=utf-8' );

// Pull from cached helper; avoid direct DB calls in this view.
$rows = array();
if ( function_exists( 'ysmap_get_custom_urls' ) ) {
	$rows = ysmap_get_custom_urls();
}

echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
echo "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";

if ( ! empty( $rows ) ) {
	foreach ( $rows as $r ) {
		// Support object or associative-array rows.
		$loc_raw = is_object( $r ) ? ( $r->url ?? '' ) : ( isset( $r['url'] ) ? $r['url'] : '' );
		$last    = is_object( $r ) ? ( $r->last_modified ?? '' ) : ( isset( $r['last_modified'] ) ? $r['last_modified'] : '' );
		$ts      = $last ? strtotime( $last ) : time();

		echo "  <url>\n";
		printf( "    <loc>%s</loc>\n", esc_url( $loc_raw ) );

		$lastmod = gmdate( 'c', $ts );
		printf(
			"    <lastmod>%s</lastmod>\n",
			function_exists( 'esc_xml' ) ? esc_xml( $lastmod ) : esc_html( $lastmod )
		);
		echo "  </url>\n";
	}
}

echo "</urlset>";
exit;
