<?php

if ( ! defined( 'ABSPATH' ) ) exit;

// === Add meta box to all public post types ===
add_action('add_meta_boxes', function () {
    $post_types = get_post_types(['public' => true], 'names');
    foreach ($post_types as $type) {
        add_meta_box(
            'ysmap_exclude_meta',
            __('Sitemap Manager', 'sitemap-manager-pro'),
            'ysmap_render_meta_box',
            $type,
            'side'
        );
    }
});

function ysmap_render_meta_box($post) {
    $value = get_post_meta($post->ID, '_ysmap_exclude_from_sitemap', true);
    wp_nonce_field('ysmap_save_meta_box', 'ysmap_meta_box_nonce');
    ?>
    <label>
        <input type="checkbox" name="ysmap_exclude_from_sitemap" value="1" <?php echo checked($value, '1', false); ?>>
        <?php esc_html_e('Exclude from sitemap', 'sitemap-manager-pro'); ?>

    </label>
    <?php
}

// === Save meta box field ===
add_action('save_post', function ($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    // Save from meta box
   if (
       isset($_POST['ysmap_meta_box_nonce']) &&
       wp_verify_nonce(
           sanitize_text_field(wp_unslash($_POST['ysmap_meta_box_nonce'])),
           'ysmap_save_meta_box'
       )
   ) {
       // Save logic here
   }

        $value = isset($_POST['ysmap_exclude_from_sitemap']) ? '1' : '0';
        update_post_meta($post_id, '_ysmap_exclude_from_sitemap', $value);
    }

    // Save from bulk edit / quick edit
    if (
        isset($_POST['ysmap_exclude_from_sitemap_bulk']) &&
        isset($_POST['ysmap_bulk_edit_nonce']) &&
        wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['ysmap_bulk_edit_nonce'])), 'ysmap_bulk_edit_action')
    ) {
        update_post_meta($post_id, '_ysmap_exclude_from_sitemap', '1');
    } elseif (
        isset($_REQUEST['action']) &&
        $_REQUEST['action'] === 'edit' &&
        isset($_POST['ysmap_bulk_edit_nonce']) &&
        wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['ysmap_bulk_edit_nonce'])), 'ysmap_bulk_edit_action') &&
         current_user_can('edit_post', $post_id)
    ) {
        update_post_meta($post_id, '_ysmap_exclude_from_sitemap', '0');
    }


// === Add Quick Edit and Bulk Edit support ===
add_action('bulk_edit_custom_box', 'ysmap_bulk_quick_edit_checkbox', 10, 2);
add_action('quick_edit_custom_box', 'ysmap_bulk_quick_edit_checkbox', 10, 2);

function ysmap_bulk_quick_edit_checkbox($column, $post_type) {
    if ($column !== 'title') return;

    echo '<fieldset class="inline-edit-col-right"><div class="inline-edit-col">';
    echo '<label><input type="checkbox" name="ysmap_exclude_from_sitemap_bulk" value="1"> ';
    esc_html_e('Exclude from sitemap', 'sitemap-manager-pro');
    echo '</label>';
    wp_nonce_field('ysmap_bulk_edit_action', 'ysmap_bulk_edit_nonce');
    echo '</div></fieldset>';
}


// === Filter Yoast sitemap to exclude posts ===
add_filter('wpseo_sitemap_entry', function ($url, $post) {
    if (!isset($post->ID)) return $url;

    $exclude = get_post_meta($post->ID, '_ysmap_exclude_from_sitemap', true);
    if ($exclude === '1' || ysmap_should_exclude_by_taxonomy($post->ID)) {
        return false;
    }

    return $url;
}, 10, 2);

// === Exclude posts by category or tag slug ===
function ysmap_should_exclude_by_taxonomy($post_id) {
    $excluded_categories = ['noindex', 'internal-use'];
    $excluded_tags = ['private', 'hidden'];

    $post_categories = wp_get_post_terms($post_id, 'category', ['fields' => 'slugs']);
    if (array_intersect($excluded_categories, $post_categories)) return true;

    $post_tags = wp_get_post_terms($post_id, 'post_tag', ['fields' => 'slugs']);
    if (array_intersect($excluded_tags, $post_tags)) return true;

    return false;
}
