<?php
if ( ! defined( 'ABSPATH' ) ) exit;

// File: includes/tabbed_menu.php

// We only read `tab` to decide which admin screen section to show; no persistent state is changed.
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$tab_raw = isset( $_GET['tab'] ) ? wp_unslash( $_GET['tab'] ) : '';

$allowed_tabs = array( 'sitemap', 'add', 'llms', 'settings', 'instructions' );
$tab_sanitized = sanitize_key( $tab_raw );
$active_tab = in_array( $tab_sanitized, $allowed_tabs, true ) ? $tab_sanitized : 'sitemap';


// Hardcoded base with correct page slug
$base_url = admin_url('admin.php?page=sitemap-manager-pro');
?>

<!-- <h1 class="wp-heading-inline"><?php echo esc_html__('Sitemap Manager Pro', 'sitemap-manager-pro'); ?></h1> -->
<nav class="nav-tab-wrapper mt-3">
    <a href="<?php echo esc_url(add_query_arg('tab', 'sitemap', $base_url)); ?>" class="nav-tab <?php echo $active_tab === 'sitemap' ? 'nav-tab-active' : '' ?>">
        <?php echo esc_html__('Sitemap', 'sitemap-manager-pro'); ?>
    </a>
    <a href="<?php echo esc_url(add_query_arg('tab', 'add', $base_url)); ?>" class="nav-tab <?php echo $active_tab === 'add' ? 'nav-tab-active' : '' ?>">
        <?php echo esc_html__('Add to Sitemap', 'sitemap-manager-pro'); ?>
    </a>
    <a href="<?php echo esc_url(add_query_arg('tab', 'llms', $base_url)); ?>" class="nav-tab <?php echo $active_tab === 'llms' ? 'nav-tab-active' : '' ?>">
        <?php echo esc_html__('Generate LLMS.txt', 'sitemap-manager-pro'); ?>
    </a>
    <a href="<?php echo esc_url(add_query_arg('tab', 'settings', $base_url)); ?>" class="nav-tab <?php echo $active_tab === 'settings' ? 'nav-tab-active' : '' ?>">
        <?php echo esc_html__('Settings', 'sitemap-manager-pro'); ?>
    </a>
    <a href="<?php echo esc_url(add_query_arg('tab', 'instructions', $base_url)); ?>" class="nav-tab <?php echo $active_tab === 'instructions' ? 'nav-tab-active' : '' ?>">
        <?php echo esc_html__('Instructions', 'sitemap-manager-pro'); ?>
    </a>
    <a href="#" 
       class="nav-tab" 
       data-plk-open="valid-modal">
        <?php echo esc_html__('License Info', 'sitemap-manager-pro'); ?>
    </a>

</nav>
<hr class="wp-header-end">
