document.addEventListener('DOMContentLoaded', function () {
  if (typeof plkData === 'undefined') return;

  const isValid      = !!plkData.license_valid;
  const currentPage  = String(plkData.current_page || '');
  const TARGET_PAGE  = 'sitemap-manager-pro'; // only block on this page

  const overlay      = document.getElementById('plk-modal-overlay');
  const modalBlocked = document.getElementById('plk-modal-blocked');
  const modalValid   = document.getElementById('plk-modal-valid');
  const closeBtn     = document.getElementById('plk-modal-close');

  if (!overlay || !modalBlocked || !modalValid) return;

  // Keep the overlay clear of the left admin menu (folded or not).
  function setOverlayLeft() {
    const menuWrap = document.getElementById('adminmenuwrap');
    const width = menuWrap ? Math.max(0, Math.round(menuWrap.getBoundingClientRect().width)) : 0;
    overlay.style.left = width + 'px';
  }
 
  function show(el) {
    setOverlayLeft();
    overlay.classList.remove('plk-hidden');
    el.classList.remove('plk-hidden');
  }

  function hideAll() {
    overlay.classList.add('plk-hidden');
    modalBlocked.classList.add('plk-hidden');
    modalValid.classList.add('plk-hidden');
    document.body.classList.remove('plk-locked');
    document.querySelectorAll('[aria-hidden="true"]').forEach(el => {
      el.removeAttribute('aria-hidden');
      el.style.userSelect = '';
      el.style.opacity = '';
    });
  }

  // Recalculate overlay left on resize (covers menu fold/unfold).
  window.addEventListener('resize', setOverlayLeft);

  // --- VALID modal helpers (open ONLY on demand) ---
  function populateValidModal() {
    if (typeof plkLicenseData === 'undefined') return;
    const container = modalValid.querySelector('.plk-loader');
    if (!container) return;
    const d = plkLicenseData;
    const fmt = v => { const t = new Date(v); return isNaN(t) ? String(v) : t.toISOString().split('T')[0]; };
    container.innerHTML = `
      <p><strong>License Key:</strong> <code>${d.key || ''}</code> ✔<br>
      <strong>Activated:</strong> ${fmt(d.activated_on || '')}<br>
      <strong>Renewal:</strong> ${fmt(d.valid_until || '')}<br>
      <strong>Registrant:</strong> ${d.name || ''}<br>
      <strong>Email:</strong> ${d.email || ''}<br>
      <strong>Licensed Domain:</strong> ${d.domain || ''} ✔<br>
      <strong>License ID:</strong> ${d.id || ''}</p>
      <form method="post" action="">
        <input type="hidden" name="plk_clear_license" value="1">
        <input type="hidden" name="_wpnonce" value="${plkData.nonce}">
        <button type="submit" class="button">Clear License</button>
      </form>

    `;
  }

  function openValidModal() {
    if (!isValid) return; // only open if license is valid
    populateValidModal();
    show(modalValid);

    const dismiss = () => {
      hideAll();
      document.removeEventListener('keydown', onEsc);
    };
    const onEsc = (e) => { if (e.key === 'Escape') dismiss(); };

    overlay.addEventListener('click', dismiss, { once: true });
    if (closeBtn) closeBtn.addEventListener('click', dismiss, { once: true });
    document.addEventListener('keydown', onEsc);
  }

  // --- BLOCKED logic: auto-show only when invalid AND on the sitemap page ---
  const onSitemapPage = (currentPage === TARGET_PAGE);
  if (!isValid && onSitemapPage) {
    show(modalBlocked);
    document.body.classList.add('plk-locked');
    // Dim everything behind the modal for accessibility/UX.
    document.querySelectorAll('#wpbody-content *:not(#plk-modal-blocked):not(#plk-modal-blocked *)').forEach(el => {
      el.setAttribute('aria-hidden', 'true');
      el.style.userSelect = 'none';
      el.style.opacity = '0.5';
    });
  }

  // --- VALID modal: show ONLY if explicitly requested ---

  // A) Via a dedicated link/button (recommended)
  //    <a href="#" data-plk-open="valid-modal">License details</a>
  document.querySelectorAll('[data-plk-open="valid-modal"]').forEach(el => {
    el.addEventListener('click', (e) => {
      e.preventDefault();
      openValidModal();
    });
  });

  // B) One-time via URL ?force_modal=1 (handy for testing)
  const params = new URLSearchParams(window.location.search);
  if (params.get('force_modal') === '1') {
    openValidModal();
    params.delete('force_modal');
    const newQuery = params.toString();
    const newUrl = window.location.pathname + (newQuery ? '?' + newQuery : '') + window.location.hash;
    history.replaceState(null, '', newUrl); // clear the trigger
  }
});
