<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;
    include_once plugin_dir_path(__FILE__) . '/../includes/tabbed_menu.php'; 
?>
<?php
    $status = get_option('ysmap_license_status');
    $max_free = ysmap_get_max_free_count();
    $max_free_label = ysmap_get_free_level_number();
?>

<div class="wrap">
    <h2>Sitemap Manager Pro Instructions</h2>
    <p>
        Sitemap Manager gives you complete control over which URLs appear in your sitemap, including custom URLs and pages outside of WordPress. Whether you're managing a small site or a complex structure, this plugin helps fine-tune your sitemap for SEO and visibility.
    </p>

    <h3>Where to Find It</h3>
    <p>
        You can access Sitemap Manager Pro under the <strong>Tools</strong> menu in your WordPress dashboard.
    </p>

    <h3>Getting Started</h3>
    <ol>
        <li>Open the <strong>Sitemap</strong> tab to view every URL currently in your sitemap.</li>
        <li>Use the <strong>Post Type</strong> dropdown to filter by content type (Posts, Pages, and any custom post types).</li>
        <li>Use the <strong>Directory</strong> dropdown to filter by URL path (for example, <code>/blog/</code>).</li>
        <li>Use <strong>Search</strong> to find words or terms in both <em>titles</em> and <em>URLs</em>.</li>
        <li>Click the <strong>NoIndex</strong> button to show only items marked <em>noindex</em>.</li>
        <li>Click the <strong>Excluded</strong> button to show only URLs you’ve excluded.</li>
        <li><strong>Exclude a URL:</strong> tick its checkbox, then click <em>Save Changes</em> at the bottom.</li>
        <li><strong>Sort the sitemap</strong> by clicking the <em>Title</em>, <em>Date</em>, or <em>URL</em> table headers.</li>
        <li><strong>Export the sitemap:</strong> use the download button (top right of the Sitemap table) to export a CSV of the entire enhanced sitemap.</li>
    </ol>


    <h3>Plugin Tabs Overview</h3>
    <ul>
        <li><strong><a href="/wp-admin/admin.php?page=sitemap-manager-pro&tab=sitemap">Sitemap</a></strong>: View, search, and exclude URLs from your sitemap. The list is sortable by title and date.</li>
        <li><strong><a href="/wp-admin/admin.php?page=sitemap-manager-pro&tab=add">Add to Sitemap</a></strong>: Manually insert custom URLs not handled by WordPress. The system will attempt to fetch the page title and modified date.</li>
        <li><strong><a href="/wp-admin/admin.php?page=sitemap-manager-pro&tab=llms">Generate LLMS.txt</a></strong>: Generate an llms.txt file to help Large Language Models learn about you.</li>
        <li><strong><a href="/wp-admin/admin.php?page=sitemap-manage-pror&tab=settings">Settings & License</a></strong>: Manage your license key and plugin settings.</li>
        
    </ul>

    <h3>Licensing</h3>
    
    <?php if ($status === 'valid'): ?>
        <p>
            You are currently using <strong>Sitemap Manager Pro</strong>. Your license is active.
        </p>
        <p>
            You can view or manage your license right now. 
                        <a href="<?php echo esc_url( add_query_arg( 'force_modal', '1', admin_url( 'tools.php?page=sitemap-manager-pro&tab=settings' ) ) ); ?>"
               data-plk-open="license-modal">
               View License Info
            </a>.
        </p>

    <?php else: ?>
        <p>
            Your license appears to be missing or inactive.
        </p>
        <p>
            To activate Sitemap Manager Pro and access support and future updates, please visit the 
            <a href="https://pluginlicensingkit.com/apps/sitemap-manager-pro/" target="_blank">Sitemap Manager Pro page</a> or go to the 
            <a href="/wp-admin/admin.php?page=sitemap-manager&tab=settings">Settings & License</a> tab to enter your license key.
        </p>
    <?php endif; ?>

</div>
<?php require_once plugin_dir_path(__DIR__) . '/includes/footer.php'; ?>
