<?php
if (!defined('ABSPATH')) exit;


// Load the primary menu
$locations = get_nav_menu_locations();
if (!isset($locations['primary']) || !$locations['primary']) {
    echo '<div class="notice notice-error"><p>Primary menu not found. Please assign a menu to the "Primary" location under Appearance > Menus.</p></div>';
    return;
}

$menu_id = $locations['primary'];
$menu_items = wp_get_nav_menu_items($menu_id);


// Safety check
if (!$menu_items || is_wp_error($menu_items)) {
    echo '<div class="notice notice-error"><p>Primary menu not found. Please assign a menu to the "Primary" location under Appearance > Menus.</p></div>';
    return;
}

// Organize by parent/child
$tree = [];
foreach ($menu_items as $item) {
    if ($item->menu_item_parent == 0) {
	   $tree[$item->ID] = ['item' => $item, 'children' => []];
    } else {
	   $tree[$item->menu_item_parent]['children'][] = $item;
    }
}

// Build output
$llms_lines = [];
foreach ($tree as $branch) {
    $parent = $branch['item'];
    $llms_lines[] = '[' . $parent->title . '](' . esc_url($parent->url) . ')';

    foreach ($branch['children'] as $child) {
	   $llms_lines[] = '- [' . $child->title . '](' . esc_url($child->url) . ')';
    }
}

$llms_content = implode(PHP_EOL, $llms_lines);
$custom_lines = get_option('ysmap_llms_custom_lines', '');
$custom_array = array_filter(array_map('trim', explode("\n", $custom_lines)));
if (!empty($custom_array)) {
    $llms_content .= PHP_EOL . PHP_EOL . implode(PHP_EOL, $custom_array);
}

if (
    isset($_SERVER['REQUEST_METHOD']) &&
    'POST' === $_SERVER['REQUEST_METHOD'] &&
    check_admin_referer('ysmap_save_llms_custom')
) {
    $custom_lines = isset($_POST['ysmap_llms_custom_lines'])
        ? sanitize_textarea_field( wp_unslash( $_POST['ysmap_llms_custom_lines'] ) )
        : '';
    update_option('ysmap_llms_custom_lines', $custom_lines);
}


echo '<div class="wrap">';
echo '<h2>Generate LLMS.txt</h2>';
echo '<form method="post">';
wp_nonce_field('ysmap_save_llms_custom');

echo '<p>This file is auto-generated from the Primary navigation menu. Only top-level and their direct children are included.</p>';

echo '<textarea readonly rows="14" style="width:100%; font-family: monospace;">' . esc_textarea($llms_content) . '</textarea>';
echo '<h3>Additional LLMS.txt Entries</h3>';
echo '<p>You may manually add lines below. Use the format <code>[Label](https://example.com)</code> — one per line.</p>';
echo '<textarea name="ysmap_llms_custom_lines" rows="8" style="width:100%; font-family: monospace;">' . esc_textarea(get_option('ysmap_llms_custom_lines', '')) . '</textarea>';
echo '<p><button type="submit" id="llms-save-and-download" class="button button-primary">Save & Download LLMS.txt</button></p>';

// echo '<p><button type="submit" class="button">Save Custom Additions</button></p>';
// 
// echo '<p><button id="llms-download-btn" class="button button-primary">Download llms.txt File</button></p>';
echo '<p>Once the file is downloaded, place it at the root of your website.</p>'
?>


<?php
echo '</form>';
?>

<script>
document.getElementById('llms-save-and-download').addEventListener('click', function () {
    const form = this.closest('form');
    const formData = new FormData(form);

    const button = this;
    button.disabled = true;
    button.textContent = 'Saving...';

    // Define these early so they're accessible in .finally()
    const previewTextarea = document.querySelector('textarea[readonly]');
    const customTextarea = document.querySelector('textarea[name="ysmap_llms_custom_lines"]');

    fetch(window.location.href, {
	   method: 'POST',
	   body: formData,
	   credentials: 'same-origin'
    })
    .then(() => {
	   const fullContent = previewTextarea.value;

	   const blob = new Blob([fullContent], { type: 'text/plain' });
	   const url = URL.createObjectURL(blob);

	   const a = document.createElement('a');
	   a.href = url;
	   a.download = 'llms.txt';
	   document.body.appendChild(a);
	   a.click();
	   document.body.removeChild(a);
	   URL.revokeObjectURL(url);
    })
    .catch((error) => {
	   alert('Something went wrong while saving.');
	   console.error(error);
    })
    .finally(() => {
	   button.disabled = false;
	   button.textContent = 'Save & Download LLMS.txt';
	   if (customTextarea) {
		  customTextarea.value = ''; // ✅ Clear custom additions
	   }
    });
});
</script>


<?php
echo '</div>';
