<?php

if ( ! defined( 'ABSPATH' ) ) exit;

// File: views/settings.php
$method = isset( $_SERVER['REQUEST_METHOD'] )
? sanitize_text_field( wp_unslash( (string) $_SERVER['REQUEST_METHOD'] ) )
: '';

include_once plugin_dir_path(__FILE__) . '/../includes/tabbed_menu.php';

if (!current_user_can('manage_options')) return;

$license_key = get_option('ysmap_license_key', '');
$status = get_option('ysmap_license_status');
$debug_output = '';
$max_free = ysmap_get_max_free_count();

if (isset($_GET['license_cleared'])) {
    echo '<div class="notice notice-warning"><p>License cleared.</p></div>';
}

// Clear license
if (
    'POST' === strtoupper( $method ) &&
    isset( $_POST['ysmap_clear_license'] ) &&
    check_admin_referer( 'ysmap_clear_license' )
) {
    delete_option('ysmap_license_key');
    delete_option('ysmap_license_status');
    delete_option('ysmap_license_active_date');
    delete_option('ysmap_license_valid_until');
    delete_option('ysmap_license_name');
    delete_option('ysmap_license_email');
    delete_option('ysmap_license_id');
    delete_option('ysmap_domain');

    wp_redirect( admin_url( 'tools.php?page=sitemap-manager-pro&tab=settings&license_cleared=1' ) );
    exit;
}




// Validate license
if (
    'POST' === strtoupper( $method ) &&
    isset( $_POST['ysmap_license_key'] ) &&
    check_admin_referer( 'ysmap_save_license' )
) {
    // Unsplash then sanitize the license key (case-sensitive; do NOT use sanitize_key).
    $new_key  = sanitize_text_field( wp_unslash( (string) $_POST['ysmap_license_key'] ) );
    $site_url = trailingslashit( strtolower( home_url() ) );

    $request_url = add_query_arg(
        array(
            'license'  => $new_key,   // no rawurlencode here; add_query_arg encodes for us
            'site_url' => $site_url,
        ),
        'https://pluginlicensingkit.com/activation/license-check.php'
    );

    $response = wp_safe_remote_get( $request_url, array( 'timeout' => 10 ) );

    if ( is_wp_error( $response ) ) {
        $status = 'invalid';
    } else {
        $body = wp_remote_retrieve_body( $response );
        $json = json_decode( $body, true );

        if ( ! empty( $json['status'] ) && $json['status'] === 'valid' ) {
            update_option( 'ysmap_license_key',         $new_key );
            update_option( 'ysmap_license_status',      'valid' );
            update_option( 'ysmap_license_active_date', $json['activated_at'] ?? gmdate( 'Y-m-d' ) );
            update_option( 'ysmap_license_valid_until', $json['expires']      ?? gmdate( 'Y-m-d', strtotime( '+1 year' ) ) );
            update_option( 'ysmap_license_name',        $json['name']        ?? '' );
            update_option( 'ysmap_license_email',       $json['email']       ?? '' );
            update_option( 'ysmap_license_id',          $json['license_id']  ?? '' );
            update_option( 'ysmap_domain',              $json['domain']      ?? '' );

            $license_key = $new_key;
            $status      = 'valid';
        } else {
            delete_option( 'ysmap_license_key' );
            delete_option( 'ysmap_license_status' );
            delete_option( 'ysmap_license_active_date' );
            delete_option( 'ysmap_license_valid_until' );
            delete_option( 'ysmap_license_name' );
            delete_option( 'ysmap_license_email' );
            delete_option( 'ysmap_license_id' );
            delete_option( 'ysmap_domain' );

            $license_key = $new_key;
            $status      = 'invalid';
        }
    }
}


?>

<div class="wrap">

<?php
if (
        isset($_SERVER['REQUEST_METHOD']) &&
        $_SERVER['REQUEST_METHOD'] === 'POST' &&
        check_admin_referer('ysmap_save_settings')
    ) {
        update_option('ysmap_per_page', max(1, intval($_POST['ysmap_per_page'] ?? 100)));
        update_option('ysmap_default_sort', sanitize_text_field(wp_unslash($_POST['ysmap_default_sort'] ?? 'date')));
        update_option('ysmap_default_order', sanitize_text_field(wp_unslash($_POST['ysmap_default_order'] ?? 'ASC')));
    
        $enabled = isset($_POST['ysmap_enable_taxonomy']) ? '1' : '0';
        update_option('ysmap_enable_taxonomy', sanitize_text_field($enabled));
    
        wp_redirect(add_query_arg('settings-updated', 'true', menu_page_url('sitemap-manager-pro', false) . '&tab=settings'));
        exit;
    }
?>
<h2><?php esc_html_e('General Settings', 'sitemap-manager-pro'); ?></h2>

<form method="post">
    <?php wp_nonce_field('ysmap_save_settings'); ?>
    <table class="form-table" border="0">
        <tr>
            <th scope="row">
                <label for="ysmap_per_page"><?php esc_html_e('Items Per Page', 'sitemap-manager-pro'); ?></label>
            </th>
            <td>
                <input name="ysmap_per_page" type="number" id="ysmap_per_page" value="<?php echo esc_attr(get_option('ysmap_per_page', 100)); ?>" class="small-text" min="1" />
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="ysmap_default_sort"><?php esc_html_e('Default Sort Column', 'sitemap-manager-pro'); ?></label>
            </th>
            <td>
                <select name="ysmap_default_sort" id="ysmap_default_sort">
                    <option value="date" <?php selected(get_option('ysmap_default_sort', 'date'), 'date'); ?>><?php esc_html_e('Date', 'sitemap-manager-pro'); ?></option>
                    <option value="title" <?php selected(get_option('ysmap_default_sort'), 'title'); ?>><?php esc_html_e('Title', 'sitemap-manager-pro'); ?></option>
                    <option value="url" <?php selected(get_option('ysmap_default_sort'), 'url'); ?>><?php esc_html_e('URL', 'sitemap-manager-pro'); ?></option>
                </select>
                &nbsp;
                <select name="ysmap_default_order" id="ysmap_default_order">
                    <option value="ASC" <?php selected(get_option('ysmap_default_order', 'ASC'), 'ASC'); ?>><?php esc_html_e('Ascending', 'sitemap-manager-pro'); ?></option>
                    <option value="DESC" <?php selected(get_option('ysmap_default_order', 'ASC'), 'DESC'); ?>><?php esc_html_e('Descending', 'sitemap-manager-pro'); ?></option>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row"><?php esc_html_e('Enable Taxonomy Exclusions', 'sitemap-manager-pro'); ?></th>
            <td>
                <label>
                    <input type="checkbox" name="ysmap_enable_taxonomy" value="1" <?php checked(get_option('ysmap_enable_taxonomy', '1'), '1'); ?> />
                    <?php esc_html_e('Display taxonomy exclusion section on sitemap page.', 'sitemap-manager-pro'); ?>
                </label>
            </td>
        </tr>
    </table>

    <?php submit_button(__('Save Settings', 'sitemap-manager-pro')); ?>
</form>




    

    <p><strong>Plugin Version:</strong> <?php echo defined('SITEMAP_MANAGER_VERSION') ? esc_html(SITEMAP_MANAGER_VERSION) : esc_html__('unknown', 'sitemap-manager-pro'); ?></p>

</div>

<?php require_once plugin_dir_path(__DIR__) . '/includes/footer.php'; ?>
